#make sure NIVISA or R&S VISA is installed on the system: 
#https://www.ni.com/en-ca/support/downloads/drivers/download.ni-visa.html#346210 
#or
#https://inst.santec.com/resources/programming
#make sure pyvisa is installed via "pip install pyvisa"

import pyvisa as vs

rm = vs.ResourceManager()
#find all VISA devices connected to system
instruments=rm.list_resources()
#VID for santec is 0x2428
#PID for OPM-200 is 0xD00C
#open the first santec OPM-200 instrument found
opm200 = rm.open_resource([v for v in instruments if '0x2428' in v and 'D00C' in v][0])

#set the wavelength
#note if the module is not specified as SENS<module>:WAV 1550, then the current module will be used
#i.e SENS0:WAV 1550 and SENS:WAV 1550 are equivalent if the current module is 0
opm200.write('SENS:WAV 1550')

#set the averaging time
opm200.write('SENS:ATIM 10ms')

# get type of reading (dBm,dB or W)
print(opm200.query("SENS:UNIT?"))

#display the current power from the current module
#this value should match the front panel display
print(opm200.query("SENSe:POWer?\n"))

#close the connection when done
opm200.close()
#close the session when done
rm.close()

